import { TrendingUp, Mail, Phone, MapPin, Clock, Linkedin, Twitter, Instagram } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-marketing">
      <div className="container">
        <div className="footer-content-marketing">
          <div className="footer-section-marketing">
            <div className="footer-logo-marketing">
              <div className="footer-logo-icon-wrapper-marketing">
                <TrendingUp className="footer-logo-icon-marketing" size={28} />
              </div>
              <h2 className="footer-logo-text-marketing">MARKETPRO</h2>
            </div>
            <p className="footer-description-marketing">
              Профессиональные курсы по маркетингу от практикующих экспертов. 
              Современные методики и реальные кейсы для вашего роста.
            </p>
            <div className="footer-social-marketing">
              <a href="#" className="social-link-marketing">
                <Linkedin size={20} />
              </a>
              <a href="#" className="social-link-marketing">
                <Twitter size={20} />
              </a>
              <a href="#" className="social-link-marketing">
                <Instagram size={20} />
              </a>
            </div>
          </div>
          <div className="footer-section-marketing">
            <h3 className="footer-title-marketing">Навигация</h3>
            <ul className="footer-links-marketing">
              <li><a href="/">Мои курсы</a></li>
              <li><a href="/enroll">Записаться</a></li>
              <li><a href="#">О нас</a></li>
              <li><a href="#">Отзывы</a></li>
            </ul>
          </div>
          <div className="footer-section-marketing">
            <h3 className="footer-title-marketing">Контакты</h3>
            <ul className="footer-links-marketing">
              <li>
                <Phone size={16} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} />
                <a href="mailto:info@marketpro.ru">info@marketpro.ru</a>
              </li>
              <li>
                <MapPin size={16} />
                <span>Москва, ул. Маркетинговая, 10</span>
              </li>
              <li>
                <Clock size={16} />
                <span>Пн-Пт: 9:00 - 21:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom-marketing">
          <p>&copy; 2025 MARKETPRO. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

